@php 
        $user = Auth::user();
@endphp

<div class="dashboard-container">
    <!-- <h2 class="mb-4">Dashboard</h2> -->
    <div class="dashboard-grid">

        <a href="/dashboard" class="dashboard-box">
            <i class="bi bi-house"></i>
            <span>Dashboard</span>
        </a>
        @if($user['level']==='1')
        <a href="/usercreate" class="dashboard-box">
            <i class="bi bi-person-plus"></i>
            <span>Create User</span>
        </a>
        <a href="{{url('listusers')}}" class="dashboard-box">
            <i class="bi bi-file-earmark-text"></i>
            <span>List Users</span>
        </a>
        <a href="/create-exam" class="dashboard-box">
            <i class="bi bi-journal-plus"></i>
            <span>Create Exam Session</span>
        </a>
        <a href="/view-exam" class="dashboard-box">
            <i class="bi bi-pencil-square"></i>
            <span>List Exam</span>
        </a>
        @elseif($user['level']==='1'||$user['level']==='2')
        <a href="/create-exam" class="dashboard-box">
            <i class="bi bi-journal-plus"></i>
            <span>Create Exam Session</span>
        </a>
        <a href="/view-exam" class="dashboard-box">
            <i class="bi bi-pencil-square"></i>
            <span>List Exam</span>
        </a>
        @else
        <a href="/scanqr-record" class="dashboard-box">
            <i class="bi bi-qr-code"></i>
            <span>Scan QR Code</span>
        </a>
        <a href="/scanner-camera" class="dashboard-box">
            <i class="bi bi-qr-code"></i>
            <span>Camera QR Code</span>
        </a>
        <a href="/view-record" class="dashboard-box">
            <i class="bi bi-pencil-square"></i>
            <span>My Record Exam</span>
        </a>
        @endif
        <a href="/settingsprofile" class="dashboard-box">
            <i class="bi bi-gear"></i>
            <span>My Profile</span>
        </a>
        <a href="/logout" class="dashboard-box">
            <i class="bi bi-box-arrow-in-left"></i>
            <span>Log Out</span>
        </a>
    </div>
</div>

@if($user['created_at']==$user['updated_at']&&$user['id']!=1) 

<hr>
<div class="dashboard-container">
    <div class="dashboard-list">
<form action="{{ url('updatePassword') }}" method="POST" id="passwordForm">
    @csrf

<div class="mb-3">
  <label for="dataInput" class="form-label">Password</label>
    <input type="hidden" class="form-control" id="userid" name="userid" value="{{$user['id']}}">
    <input type="password" class="form-control" id="password" name="password" placeholder="Password" value="">
</div>


<div class="mb-3">
  <label for="dataInput" class="form-label">Confirm Password</label>
  <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Confirm Password" value="">
</div>

    <div class="mb-3">
        <ul id="requirements" style="color:red">
        <li id="lowercase">At least one lowercase letter</li>
        <li id="uppercase">At least one uppercase letter</li>
        <li id="number">At least one number</li>
        <li id="symbol">At least one special character (@$!%*?&#)</li>
        <li id="length">Minimum 8 characters</li>
        </ul>
    </div>

    

    <button class="btn btn-primary" type="submit" id="submitBtn" disabled>Update Password</button>
</form>
    </div>
</div>

@endif